/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.client.CTMTexture;
import team.chisel.ctm.api.client.TextureContext;

public class TextureContextMap {
    private final Map<CTMTexture<?>, TextureContext> contextMap = new HashMap();
    private final LongList dataList = new LongArrayList();

    public void fill(Collection<CTMTexture<?>> textures, class_2680 state, class_1920 world, class_2338 pos) {
        for (CTMTexture<?> texture : textures) {
            TextureContext context = texture.getType().getTextureContext(state, world, pos, texture);
            if (context == null) continue;
            this.contextMap.put(texture, context);
            this.dataList.add(context.serialize());
        }
    }

    public void reset() {
        this.contextMap.clear();
        this.dataList.clear();
    }

    @Nullable
    public TextureContext getContext(CTMTexture<?> texture) {
        return this.contextMap.get(texture);
    }

    public boolean containsContext(CTMTexture<?> texture) {
        return this.contextMap.containsKey(texture);
    }

    public long[] toDataArray() {
        return this.dataList.toLongArray();
    }
}

